/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.integrations;

import com.manageengine.servicedesk.actionplugin.executor.DefaultActionInterface;
import com.manageengine.servicedesk.actionplugin.executor.ExecutorData;
import com.vistara.integrations.utils.MESDeskPlusConstants;
import com.vistara.integrations.utils.MESDeskPlusProperties;
import com.vistara.sdk.dto.incident.BusinessImpact;
import com.vistara.sdk.dto.incident.Incident;
import com.vistara.sdk.dto.incident.Urgency;
import com.vistara.sdk.incident.IncidentAPIClient;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ManageEngineSDeskPlusSDK
extends DefaultActionInterface
implements MESDeskPlusConstants {
    private static MESDeskPlusProperties configProps = null;
    private static Logger logger = Logger.getLogger(ManageEngineSDeskPlusSDK.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject execute(ExecutorData executorData) throws Exception {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = null;
        long l = System.currentTimeMillis();
        try {
            String string;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("OpsRamp Plugin - Started integration processing  @ " + new Date(l));
            }
            configProps = MESDeskPlusProperties.getInstance();
            ExecutorData executorData2 = executorData;
            jSONObject2 = executorData2.getDataJSON();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("OpsRamp Plugin - requestJson: " + jSONObject2);
                logger.info("OpsRamp Plugin - diffJson: " + executorData2.getDiffJSON());
                logger.info("OpsRamp Plugin - htmlJson: " + executorData2.getHtmlDataJson());
                logger.info("OpsRamp Plugin - Additional Props: " + executorData2.getAdditionalProps());
                logger.info("OpsRamp Plugin - requestType: " + jSONObject2.get("request_type"));
                logger.info("OpsRamp Plugin - requestTypeName: " + ((JSONObject)jSONObject2.get("request_type")).getString("name"));
            }
            if ((string = ((JSONObject)jSONObject2.get("request_type")).getString("name")) == null || string.equalsIgnoreCase("")) {
                throw new Exception("Invalid request type received in reqJsonObj. Integration available for only request type : Incident");
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("OpsRamp Plugin - reqType: " + string);
            }
            switch (string.toUpperCase()) {
                case "INCIDENT": {
                    Object object;
                    Object object2;
                    IncidentAPIClient incidentAPIClient = this.initiateOpsRampClient();
                    String string2 = null;
                    if (jSONObject2.get(configProps.getConfiguration("filed.name", "sdp")) != null) {
                        object2 = (JSONObject)jSONObject2.get(configProps.getConfiguration("filed.name", "sdp"));
                        object = ((JSONObject)object2).get(configProps.getConfiguration("incident.field.mapping", "sdp"));
                        if (!object.equals(null)) {
                            string2 = (String)object;
                            if (logger.isLoggable(Level.INFO)) {
                                logger.info("OpsRamp Plugin - opsRampIncId: " + string2);
                            }
                        } else if (logger.isLoggable(Level.INFO)) {
                            logger.info("OpsRamp Plugin - incId: " + object);
                        }
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("OpsRamp Incident Id : " + string2);
                    }
                    object2 = null;
                    object = null;
                    object = string2 == null || "".equals(string2) ? "Create" : "Update";
                    Incident incident = this.prepareOpsRampIncicent(jSONObject2, incidentAPIClient);
                    if ("Create".equals(object)) {
                        object2 = incidentAPIClient.createIncident(incident);
                    } else {
                        incident.setId(string2);
                        object2 = incidentAPIClient.updateIncident(incident);
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("OpsRamp Plugin - Response received for " + (String)object + " incident: " + (String)object2);
                    }
                    jSONObject = this.parseResponse((String)object2, (String)object);
                    return jSONObject;
                }
                default: {
                    throw new Exception("Invalid request type '" + string + "' received. Integration not available for this type");
                }
            }
        }
        catch (Exception exception) {
            logger.severe("OpsRamp Plugin - Integration failed, Reason: " + exception);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("result", "failure");
            jSONObject3.put("message", exception.getMessage());
            return jSONObject;
        }
        finally {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("OpsRamp Plugin - Time taken to integration is: " + this.getIntgProcessTime(l));
            }
        }
    }

    private IncidentAPIClient initiateOpsRampClient() throws Exception {
        IncidentAPIClient incidentAPIClient = IncidentAPIClient.getInstance(configProps.getConfiguration("opsramp.client.id", "opsramp"));
        incidentAPIClient.setApiBaseURI(configProps.getConfiguration("opsramp.api.url", "opsramp"));
        incidentAPIClient.setOAUTH2Authentication(configProps.getConfiguration("opsramp.api.key", "opsramp"), configProps.getConfiguration("opsramp.api.secret", "opsramp"));
        if (logger.isLoggable(Level.INFO)) {
            logger.info("OpsRamp Plugin - Api URL: " + incidentAPIClient.getApiBaseURI());
        }
        return incidentAPIClient;
    }

    private Incident prepareOpsRampIncicent(JSONObject jSONObject, IncidentAPIClient incidentAPIClient) throws Exception {
        Object object;
        Incident incident = new Incident();
        incident.setSubject(jSONObject.getString("subject"));
        incident.setDescription(jSONObject.getString("description"));
        if (!jSONObject.get("priority").equals(null)) {
            object = ((JSONObject)jSONObject.get("priority")).getString("name");
            incident.setPriority(configProps.getConfiguration((String)object, "priority"));
        }
        if (!jSONObject.get("impact").equals(null)) {
            object = new BusinessImpact();
            ((BusinessImpact)object).setName(((JSONObject)jSONObject.get("impact")).getString("name"));
            incident.setBusinessImpact((BusinessImpact)object);
        }
        if (!jSONObject.get("urgency").equals(null)) {
            object = new Urgency();
            ((Urgency)object).setName(((JSONObject)jSONObject.get("urgency")).getString("name"));
            incident.setUrgency((Urgency)object);
        }
        if (!jSONObject.get("status").equals(null)) {
            object = ((JSONObject)jSONObject.get("status")).getString("name");
            incident.setStatus(configProps.getConfiguration((String)object, "status"));
        }
        incident.setExtTicketId(jSONObject.getString("id"));
        return incident;
    }

    private JSONObject parseResponse(String string, String string2) throws Exception {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONObject jSONObject2 = new JSONObject(string);
            int n = Integer.parseInt((String)jSONObject2.get("status"));
            String string3 = (String)jSONObject2.get("status_message");
            JSONObject jSONObject3 = new JSONObject(string3);
            if (n == 200) {
                String string4 = "";
                String string5 = (String)jSONObject3.get("id");
                if ("Create".equalsIgnoreCase(string2)) {
                    string4 = "Incident created in OpsRamp with Id: " + string5;
                    this.prepareSDeskPplusOperationObj(jSONObject, string5);
                } else if ("Update".equalsIgnoreCase(string2)) {
                    string4 = "Incident: " + string5 + " updated  in OpsRamp";
                }
                jSONObject.put("result", "success");
                jSONObject.put("message", string4);
            } else {
                String string6 = (String)jSONObject3.get("message");
                jSONObject.put("result", "failure");
                jSONObject.put("message", string6);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("OpsRamp Plugin - SDesk Plus result JSON prepared from OpsRamp Incident create response: " + jSONObject);
            }
        }
        catch (Exception exception) {
            logger.severe("Failed to parse incident response, Reason: " + exception.getMessage());
            throw exception;
        }
        return jSONObject;
    }

    private JSONObject prepareSDeskPplusOperationObj(JSONObject jSONObject, String string) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray2 = new JSONArray();
        JSONObject jSONObject3 = new JSONObject();
        JSONObject jSONObject4 = new JSONObject();
        JSONObject jSONObject5 = new JSONObject();
        jSONObject5.put(configProps.getConfiguration("incident.field.mapping", "sdp"), string);
        jSONObject3.put(configProps.getConfiguration("filed.name", "sdp"), jSONObject5);
        jSONObject4.put("request", jSONObject3);
        jSONArray2.put(jSONObject4);
        jSONObject2.put("INPUT_DATA", jSONArray2);
        jSONObject2.put("OPERATIONNAME", configProps.getConfiguration("operation.name", "sdp"));
        jSONObject2.put("FORMAT", configProps.getConfiguration("format.version", "sdp"));
        jSONArray.put(jSONObject2);
        jSONObject.put("operation", jSONArray);
        return jSONObject;
    }

    private String getIntgProcessTime(long l) {
        String string = "Milli Seconds";
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 1000L) {
            string = "Seconds";
            if ((l2 /= 1000L) > 60L) {
                string = "Minutes";
                if ((l2 /= 60L) > 60L) {
                    l2 /= 60L;
                    string = "Hours";
                }
            }
        }
        return l2 + " " + string;
    }

    public static void main(String[] stringArray) throws Exception {
        new ManageEngineSDeskPlusSDK().execute(null);
    }
}

