/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.timeseries.collection;

import java.util.ArrayList;
import java.util.List;

public enum SourceType {
    CLOUD_PROVIDER("Cloud Provider"),
    DEVICE("Device"),
    DEVICE_GROUP("Device Group"),
    DEVICE_TYPE("Device Type"),
    LOAD_BALANCER("AWS/Load Balancer"),
    NETWORK_CARD("Network Card"),
    ORGANIZATION("Organization"),
    SERVICE("Service Group"),
    SYSTEM_RESOURCE("System Resource"),
    SYSTEM("System"),
    EBS("AWS/Volume"),
    SNAPSHOT("Snapshot"),
    RDS("AWS/RDS"),
    DYNAMO_DB("AWS/DynamoDB"),
    REDSHIFT("AWS/Redshift"),
    AUTO_SCALING("AWS/Auto Scaling"),
    SQS("AWS/SQS"),
    SNS("AWS/SNS"),
    ROUTE_53("AWS/Route 53"),
    DOCKER("Docker"),
    SECURITY_GROUP("Security Group"),
    ELASTICACHE("AWS/ElastiCache"),
    VPC("VPC"),
    KEY_PAIR("KEY_PAIR"),
    PLACEMENT_GROUP("PLACEMENT_GROUP"),
    NETWORK_INTERFACE("Network Interface"),
    ELASTICACHENODE("AWS/ElastiCache Node"),
    REDSHIFTCLUSTERNODE("AWS/Redshift Cluster Node"),
    ELASTIC_IP("Elastic Ip"),
    DEPENDENCY_GROUP("Dependency Group"),
    VISTARA_GATEWAY("Vistara Gateway"),
    VISTARA_AGENT("Vistara Agent"),
    ELASTICMAPREDUCE("AWS/EMR"),
    EMRINSTANCEGROUP("EMR Instance Group"),
    EMRSTEP("EMR Step"),
    EMRBOOTSTRAPACTION("EMR Bootsrap Action"),
    SITE("Site"),
    AFFINITY_GROUP("AffinityGroup"),
    CLOUD_SERVICE("CloudService"),
    KINESIS("AWS/Kinesis"),
    SHARD("AWS/Shard"),
    VPN("AWS/VpnConnection"),
    GLOBAL_SECONDARY_INDEX("AWS/Global Secondary Index"),
    LAMBDA("AWS/Lambda"),
    EVENTSOURCE("AWS/EventSource"),
    MACHINE_LEARNING("AWS/Machine Learning"),
    ML_BATCHPREDICTION("AWS/Batch Prediction"),
    ML_DATASOURCE("AWS/Data Source"),
    ML_EVALUATION("AWS/Evaluation"),
    CHECK("Check"),
    STORAGE_GATEWAY("AWS/StorageGateway"),
    GATEWAY_VOLUME("AWS/Gateway Volume"),
    CLOUDFRONT("AWS/CloudFront"),
    CF_ORIGIN("AWS/Origin"),
    WEBSITE("WebSite"),
    SQL_SERVER("SQL Server"),
    SQL_DATABASE("SQL Database"),
    RESOURCE_GROUP("Resource Group"),
    VM_EVENT("Virtual Machine Event"),
    VM_SNAPSHOT("Virtual Machine Snapshot"),
    OOB_INTERFACE("OOB Interface"),
    DATA_CENTER("Data Center"),
    VI_DATASTORE("Data Store"),
    VI_CLUSTER("Cluster"),
    SYNTHETIC("Synthetic"),
    ECS_CLUSTER("ECS Cluster"),
    WORKSPACE_DIRECTORY("WorkSpace Directory");

    private String name;
    private static List<SourceType> cloudResources;
    private static List<SourceType> defaultResources;

    private SourceType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static SourceType lookup(String name) {
        for (SourceType type : SourceType.values()) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return null;
    }

    public String getAvailabilityMetricName() {
        switch (this) {
            case SERVICE: {
                return "SERVICE_AVAILABILITY_STATUS_METRIC";
            }
        }
        return "cloud.instance.state";
    }

    public static SourceType getSourcType(String name) {
        for (SourceType type : SourceType.values()) {
            if (name.equalsIgnoreCase(type.name())) {
                return type;
            }
            if (!name.equalsIgnoreCase(type.getName())) continue;
            return type;
        }
        return null;
    }

    public static boolean isCloudResource(SourceType resourceType) {
        return cloudResources.contains((Object)resourceType);
    }

    public static boolean isDefaultResource(SourceType resourceType) {
        return defaultResources.contains((Object)resourceType);
    }

    public static SourceType getSourceTypeByClassCode(String classCode) {
        if (classCode.equalsIgnoreCase("loadbalancer")) {
            return LOAD_BALANCER;
        }
        if (classCode.equalsIgnoreCase("rdsdbinstance")) {
            return RDS;
        }
        if (classCode.equalsIgnoreCase("sns")) {
            return SNS;
        }
        if (classCode.equalsIgnoreCase("sqs")) {
            return SQS;
        }
        if (classCode.equalsIgnoreCase("autoscalinggroup")) {
            return AUTO_SCALING;
        }
        if (classCode.equalsIgnoreCase("redshiftcluster")) {
            return REDSHIFT;
        }
        if (classCode.equalsIgnoreCase("redshiftclusternode")) {
            return REDSHIFTCLUSTERNODE;
        }
        if (classCode.equalsIgnoreCase("route53")) {
            return ROUTE_53;
        }
        if (classCode.equalsIgnoreCase("dynamodb")) {
            return DYNAMO_DB;
        }
        if (classCode.equalsIgnoreCase("networkinterface")) {
            return NETWORK_INTERFACE;
        }
        if (classCode.equalsIgnoreCase("placementgroup")) {
            return PLACEMENT_GROUP;
        }
        if (classCode.equalsIgnoreCase("elasticip")) {
            return ELASTIC_IP;
        }
        if (classCode.equalsIgnoreCase("keypair")) {
            return KEY_PAIR;
        }
        if (classCode.equalsIgnoreCase("vpc")) {
            return VPC;
        }
        if (classCode.equalsIgnoreCase("securitygroup")) {
            return SECURITY_GROUP;
        }
        if (classCode.equalsIgnoreCase("elasticachecluster")) {
            return ELASTICACHE;
        }
        if (classCode.equalsIgnoreCase("elasticachenode")) {
            return ELASTICACHENODE;
        }
        if (classCode.equalsIgnoreCase("ebs")) {
            return EBS;
        }
        if (classCode.equalsIgnoreCase("cloudservice")) {
            return CLOUD_SERVICE;
        }
        if (classCode.equalsIgnoreCase("affinitygroup")) {
            return AFFINITY_GROUP;
        }
        if (classCode.equalsIgnoreCase("emrcluster")) {
            return ELASTICMAPREDUCE;
        }
        if (classCode.equalsIgnoreCase("emrbootstrap")) {
            return EMRBOOTSTRAPACTION;
        }
        if (classCode.equalsIgnoreCase("emrinstancegrp")) {
            return EMRINSTANCEGROUP;
        }
        if (classCode.equalsIgnoreCase("emrstep")) {
            return EMRSTEP;
        }
        SourceType st = SourceType.lookup(classCode);
        if (st != null) {
            return st;
        }
        return DEVICE;
    }

    public static List<SourceType> getCloudResourceTypes() {
        return cloudResources;
    }

    static {
        cloudResources = new ArrayList<SourceType>(){
            {
                this.add(EBS);
                this.add(SNAPSHOT);
                this.add(LOAD_BALANCER);
                this.add(RDS);
                this.add(SNS);
                this.add(SQS);
                this.add(REDSHIFT);
                this.add(AUTO_SCALING);
                this.add(ROUTE_53);
                this.add(DYNAMO_DB);
                this.add(ELASTICACHE);
                this.add(VPC);
                this.add(KEY_PAIR);
                this.add(PLACEMENT_GROUP);
                this.add(NETWORK_INTERFACE);
                this.add(REDSHIFTCLUSTERNODE);
                this.add(ELASTICACHENODE);
                this.add(ELASTIC_IP);
                this.add(ELASTICMAPREDUCE);
                this.add(EMRBOOTSTRAPACTION);
                this.add(EMRINSTANCEGROUP);
                this.add(EMRSTEP);
                this.add(CLOUD_SERVICE);
                this.add(AFFINITY_GROUP);
                this.add(KINESIS);
                this.add(SHARD);
                this.add(VPN);
                this.add(GLOBAL_SECONDARY_INDEX);
                this.add(LAMBDA);
                this.add(EVENTSOURCE);
                this.add(MACHINE_LEARNING);
                this.add(ML_BATCHPREDICTION);
                this.add(ML_EVALUATION);
                this.add(ML_DATASOURCE);
                this.add(STORAGE_GATEWAY);
                this.add(GATEWAY_VOLUME);
                this.add(CLOUDFRONT);
                this.add(CF_ORIGIN);
                this.add(WEBSITE);
                this.add(SQL_SERVER);
                this.add(SQL_DATABASE);
                this.add(RESOURCE_GROUP);
                this.add(VM_EVENT);
                this.add(VM_SNAPSHOT);
                this.add(OOB_INTERFACE);
                this.add(DATA_CENTER);
                this.add(VI_DATASTORE);
                this.add(VI_CLUSTER);
            }
        };
        defaultResources = new ArrayList<SourceType>(){
            {
                this.add(DEVICE);
                this.add(EBS);
                this.add(SNAPSHOT);
                this.add(LOAD_BALANCER);
                this.add(RDS);
                this.add(SNS);
                this.add(SQS);
                this.add(REDSHIFT);
                this.add(AUTO_SCALING);
                this.add(ROUTE_53);
                this.add(DYNAMO_DB);
                this.add(ELASTICACHE);
                this.add(VPC);
                this.add(REDSHIFTCLUSTERNODE);
                this.add(ELASTICACHENODE);
                this.add(ELASTICMAPREDUCE);
                this.add(EMRBOOTSTRAPACTION);
                this.add(EMRINSTANCEGROUP);
                this.add(EMRSTEP);
                this.add(KINESIS);
                this.add(VPN);
                this.add(GLOBAL_SECONDARY_INDEX);
                this.add(LAMBDA);
                this.add(EVENTSOURCE);
                this.add(MACHINE_LEARNING);
                this.add(STORAGE_GATEWAY);
                this.add(GATEWAY_VOLUME);
                this.add(CLOUDFRONT);
                this.add(WEBSITE);
                this.add(SQL_SERVER);
                this.add(SQL_DATABASE);
                this.add(CHECK);
            }
        };
    }
}

